import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { mutationResponse } from "../../util/processResponse.js";

const initialState = {
    newRefund: {},
    loading: false,
};

export const postNewRefund = createAsyncThunk(
    "user/postNewRefund",
    async (obj) => {
        try {
            const { access_token, urlPost, method, formData } = obj;
            const data = await mutationResponse(
                urlPost,
                method,
                formData,
                access_token
            );
            return data;
        } catch (err) {
            return;
        }
    }
);

const postNewRefundSlice = createSlice({
    name: "user",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(postNewRefund.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(postNewRefund.fulfilled, (state, { payload }) => {
            state.newRefund = payload;
            state.loading = false;
        });
        builder.addCase(postNewRefund.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default postNewRefundSlice.reducer;
